/*
  blinddial.cpp
  David Rowe 17/4/02

  Demonstrates blind dialling (no dial tone detection).
*/

#include "../src/vpbapi.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "kbhit.h"

#define NDIG 12

void verbose(int);
int arg_exists(int argc, char *argv[], char *arg);

char digit[] = "1234567890#*";

int main(int argc, char *argv[]) {
	int       h1, i;
	VPB_TONE  tone;
	VPB_EVENT e;
	char      s[VPB_MAX_STR];

	if (argc < 3) {
		printf("usage: blinddial Port[1..] Number [--low]"
		       " [--high]\n");
		exit(0);
	}
	
	h1 = vpb_open(1,atoi(argv[1]));

	if (arg_exists(argc, argv, "--low")) { 
	  // set high tone amplitudes to 0 - used for testing levels
	  for(i=0; i<NDIG; i++) {
	    vpb_gettone(digit[i], &tone);
	    tone.level2 = -100;
	    tone.ton = 2000;
	    tone.toff = 1000;
	    vpb_settone(digit[i], &tone);
	  }
	}

	if (arg_exists(argc, argv, "--high")) { 
	  // set low tone amplitudes to 0 - used for testing levels
	  for(i=0; i<NDIG; i++) {
	    vpb_gettone(digit[i], &tone);
	    tone.level1 = -100;
	    tone.ton = 2000;
	    tone.toff = 1000;
	    vpb_settone(digit[i], &tone);
	  }
	}

	vpb_sethook_sync(h1,VPB_OFFHOOK);
	vpb_sleep(2000);
	vpb_dial_sync(h1, argv[2]);
	printf("press return to hang up....\n");
	while(!kbhit()) {
		while(vpb_get_event_async(&e) == VPB_OK) {
			vpb_translate_event(&e, s);
			printf("%s",s);

		}
		vpb_sleep(10);
	}
	vpb_sethook_sync(h1,VPB_ONHOOK);
	vpb_close(h1);

	return 0;
}

int arg_exists(int argc, char *argv[], char *arg) {
  int i;

  for(i=0; i<argc; i++)
    if (strcmp(argv[i],arg) == 0)
      return i;

  return 0;
}


